<?php

namespace App\Bll;

use App\Mail\RegisterOtpMail;
use \App\Models\Otp as OTPModel;
use Illuminate\Support\Facades\Log;

class OTP
{
    protected $module;
    protected $type;
    protected $data;
    protected $email;
    protected $action;
    protected $method;
    private int $maxAttempts = 5;

    /**
     * OTP constructor.
     * @param $action
     * @param $data
     * @param string $type
     * @param string $method
     */

    public function __construct($action, $data, $type = 'phone',$method = 'sms')
    {
        $this->action = $action;
        $this->type = $type;
        $this->data = $data;
        $this->method = $method;
    }

    public function sendOtp()
    {
        if (!$this->checkMaxAttempts()) {
            return false;
        }
        $otp = $this->generateOtp();
        Log::info('OTP sendOtp called');
        $this->saveOtp($otp);
        return true;
    }

    public function verifyOtp($userOtp)
    {

        $otp = OTPModel::where($this->type, $this->data)
            ->where('otp', $userOtp)
            ->where('action', $this->action)
            ->where('expire_at', '>', now())
            ->orderBy('id', 'desc')->first();
        if ($otp) {
            OTPModel::where($this->type, $this->data)->delete();
            return true;
        }
        return false;
    }

    public function resendOtp()
    {
        if (!$this->checkMaxAttempts()) {
            return false;
        }
        $otp = $this->generateOtp();
        $this->saveOtp($otp);
        return true;
    }

    public function checkVrifyedData()
    {
        $otp = OTPModel::where($this->type, $this->data)
            ->orderBy('id', 'desc')
            ->where('action', $this->action)
            ->withTrashed()
            ->first();
        return $otp && $otp->deleted_at?->addMinutes(10) > now();
    }


    private function generateOtp(): int
    {
        $code = random_int(1000, 99999);
        if ($this->action === "forget_password") {
            $msg = "مرحبًا لإعادة تعيين كلمة المرور، يُرجى استخدام الكود التالي للتفعيل: " . $code . " تنتهي صلاحية الكود بعد 10 دقائق .";
        } else {
            $msg = "مرحبًا لإكمال عملية التسجيل، يُرجى استخدام الكود التالي للتفعيل: " . $code . " تنتهي صلاحية الكود بعد 10 دقائق .";
        }

        if ($this->method !== 'sms') {
            // send email
            $sendgrid = new RegisterOtpMail();
            $sendgrid->send($this->method, $code);
        } else {
            // send sms
            $twilio = new Twilio($this->data);
            $twilio->sendMessage($msg);
        }
        return $code;


    }

    private function checkMaxAttempts()
    {
        // get attempts last 24 hours
        $attempts = OTPModel::where($this->type, $this->data)
            ->where('created_at', '>', now()->subDay())
            ->withTrashed()
            ->count();

        return $attempts < $this->maxAttempts;
    }

    private function saveOtp($otp)
    {
        OTPModel::create([
            $this->type => $this->data,
            'action' => $this->action,
            'otp' => $otp,
            'expire_at' => now()->addMinutes(5)
        ]);
    }

}
