<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Log;
use SendGrid;
use SendGrid\Mail\Mail as SendGridMail;

class RegisterOtpMail
{
    protected $sendgrid;

    public function __construct()
    {
        $this->sendgrid = new SendGrid(env('SENDGRID_API_KEY'));
    }

    public function send($to, $otp)
    {
        $body = "<div style='background-color: #f8f9fa; padding: 20px;'>";
        $body .= "<div style='background-color: #fff; padding: 20px; border-radius: 10px;'>";
        $body .= "<img src='https://schools.school-points.com/assets/sidebar-logo-BneU2QYm.png' alt='School Points' style='width: 100px;'>";
        $body .= "<h1 style='color: #343a40;'>OTP: $otp</h1>";
        $body .= "</div>";
        $body .= "</div>";

        $email = new SendGridMail();
        $email->setFrom('no-replay@school-points.com', 'Point');
        $email->setSubject('Point - OTP');
        $email->addTo($to);
        $email->addContent("text/html", $body); // Use text/html for HTML content

        try {
            $response = $this->sendgrid->send($email);
            Log::info('SendGrid response: ' . $response->statusCode());
            Log::info($response->body());
            return $response;
        } catch (\Exception $e) {
            Log::error('Caught exception: ' . $e->getMessage());
            return null;
        }
    }
}
