<?php

namespace App\Modules\Articles\Models;

use App\Bll\Utility;
use Illuminate\Database\Eloquent\Model;

class ArticlesData extends Model
{
    protected $table = 'articles_data';
    protected $guarded = [];
    public $timestamps = true;

    protected static function boot()
    {
        parent::boot();

        static::creating(function (ArticlesData $ArticlesData) {
            $ArticlesData->lang_id = Utility::lang_id();
        });
        static::addGlobalScope('lang_id', function ($query) {
            $query->where('lang_id', Utility::lang_id());
        });

    }

}
