<?php

namespace App\Modules\Articles\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ArticlesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [

            'id' => $this->id,
            'image' => $this->image,
            'web_image' => $this->image ? asset($this->image) : null,
            'title' => $this?->Data?->first()?->title,
            'content' => $this?->Data?->first()?->content,
        ];
    }
}
