<?php

namespace App\Modules\Companies\Requests;

use App\Rules\ImageInTemp;
use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules()
    {
        return [
            'title' => ['required', 'string', 'max:255'],
            'image' => ['required', new ImageInTemp()],
            'description' => ['required', 'string'],
        ];
    }
}
