<?php

namespace App\Modules\CompanyNumbers\Services;

use App\Bll\Paths;
use App\Services\Store;
use App\Modules\CompanyNumbers\Models\CompanyNumbers;
use App\Modules\CompanyNumbers\Resources\CompanyNumbersResource;

class CompanyNumbersService extends Store
{
    protected $error;
    protected $success;
    protected $saved;

    public function __construct()
    {
        $this->resource = CompanyNumbersResource::class;
        //set messages
        $this->error = __("api.There is no Companies");
        $this->success = __('api.All Companies retrieved successfully');
        $this->saved = __('api.Companies created successfully');

        parent::__construct(CompanyNumbers::query());
    }

    public function GetAll()
    {
        return $this->Get(["company_numbers.id", "title", "numbers"], []);
    }

    public function storeData()
    {
        $this->store(["title", "numbers"], [], "", '');
        return $this->saved;
    }

    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = CompanyNumbers::where('id', $id)->first();
            if ($data != null) {
                $this->data = CompanyNumbersResource::make($data);
            }
        }
        return $this->success;
    }

    public function edit(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = CompanyNumbers::where('id', $id)->first();
            if ($data != null) {
                $this->data = CompanyNumbersResource::make($data);
            }
        }
        return $this->success;
    }

    public function updateData(int $id)
    {
        $this->update(["title", "numbers"], [], "", $id, '');
        return $this->saved;
    }

    public function deleteData(int $id)
    {
        $be = CompanyNumbers::where('id', $id)->first();
        if ($be) {
            $this->delete($id);
        } else {
            return __('api.You can not update this Companies');
        }
    }
}
