<?php

namespace App\Modules\Contact\Services;

use App\Modules\Contact\Models\Contact;
use App\Modules\Contact\Resources\ContactResource;
use App\Modules\Contact\Resources\ContactShowResource;
use App\Services\Store;

class adminContactService extends Store
{
    private const Error = "There is no Contacts available";
    private const Success = 'All Contacts retrieved successfully';
    private const Saved = 'Contacts created successfully';

    public function __construct()
    {
        $this->resource = ContactShowResource::class;
        $this->error = self::Error;
        $this->success = self::Success;
        $this->saved = self::Saved;

        parent::__construct(new Contact());
    }

    public function GetAll()
    {
        return $this->Get(['contact.id', 'name', 'phone', 'subject', 'message', "email", 'created_at'], false);
    }

    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Contact::where('id', $id)->first();
            if ($data != null) {
                $this->data = ContactResource::make($data);
            }
        }
        return 'Contacts retrieved successfully';
    }

    public function deleteData(int $id)
    {
        $this->delete($id);
    }
}
