<?php

namespace App\Modules\Founder\Services;

use App\Services\Store;
use App\Modules\Founder\Models\Founder;

class FrontFounderService extends Store
{
    private const Error = "There is no Founder available";
    private const Success = 'All Founder retrieved successfully';
    private const Saved = 'Founder created successfully';

    public function __construct()
    {
        $this->error = self::Error;
        $this->success = self::Success;
        $this->saved = self::Saved;

        parent::__construct(new Founder());
    }

    public function GetAll()
    {
        return $this->Get(
            ['founder.id', 'name', 'image', 'job_title', 'qoute'],
            ['table' => 'founder_data', 'key' => 'founder_id']

        );
    }
}
