<?php

namespace App\Modules\Projects\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\Projects\Models\Projects;

use App\Modules\Projects\Models\ProjectsCards;
use App\Modules\Projects\Resources\ProjectsResource;
use App\Modules\Projects\Resources\FrontProjectsCardsResource;

class FrontController extends Controller
{
    public function indexCards()
    {
        $projects = ProjectsCards::whereHas('Data')->with('Data')->get();
        return $this->sendResponse(FrontProjectsCardsResource::collection($projects), 'Projects');
    }

    public function indexProjects()
    {
        $projects = Projects::whereHas('Data')->with('Card', 'Links', 'Data')->get();
        return $this->sendResponse(ProjectsResource::collection($projects), 'Projects');
    }


    public function showProject($id)
    {
        $projects = Projects::whereHas('Data')->where('id', $id)->with('Card', 'Links', 'Data')->get();
        return $this->sendResponse(ProjectsResource::collection($projects), 'Projects');
    }


}
