<?php

namespace App\Modules\Projects\Models;

use App\Bll\Utility;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProjectsCards extends Model
{

    protected $table = 'projects_cards';
    protected $guarded = [];
    public $timestamps = true;

    //    belong to projects
    public function project()
    {
        return $this->belongsTo(Projects::class, 'project_id', 'id');
    }

    public function Data(): HasMany
    {
        return $this->hasMany(ProjectsCardsData::class, 'projects_cards_id', 'id')->where('lang_id', Utility::lang_id());
    }

}
