import { Button } from "@mantine/core";
import Link from "next/link";
import { useRouter } from 'next/router';
import { useTranslation } from "react-i18next";

const NavLinks = () => {
  const { pathname } = useRouter();
  const { t } = useTranslation();
  const isActive = (path: string) => pathname === path ? 'active' : '';

  return (
    <ul dir="rtl" className="flex flex-col md:flex-row px-3 py-1 bg-[#5B538442] rounded-[25px]">
      <li>
        <Button
          component={Link}
          href="/"
          variant="outline"
          className={`relative hover:bg-inherit font-medium px-8 border-none text-[16px] opacity-60 text-white duration-200 font-cairo ${isActive('/')}`}
        >
          {t('navbar.home')}
        </Button>
      </li>
      <li>
        <Button
          component={Link}
          href="/works"
          variant="outline"
          className={`hover:bg-inherit font-medium px-8 border-none text-[16px] text-white opacity-60 hover:opacity-100 duration-200 font-cairo ${isActive('/works')}`}
        >
          {t('navbar.works')}
        </Button>
      </li>
      <li>
        <Button
          component={Link}
          href="/#our-services"
          variant="outline"
          className={`hover:bg-inherit font-medium px-8 border-none text-[16px] text-white opacity-60 hover:opacity-100 duration-200 font-cairo} ${isActive('/our-services')}`}
        >
          {t('navbar.services')}
        </Button>
      </li>
      <li>
        <Button
          component={Link}
          href="/#about-us"
          variant="outline"
          className={`hover:bg-inherit font-medium px-8 border-none text-[16px] text-white opacity-60 hover:opacity-100 duration-200 font-cairo} ${isActive('/our-services')}`}
        >
          {t('navbar.AboutUs')}
        </Button>
      </li>
    </ul>
  );
};

export default NavLinks;
