import { useTranslation } from 'react-i18next';
import AnalysisIcon from "@/component/icons/AnalysisIcon";
import SectionTitle from "@/component/mucles/sectionTitle/SectionTitle";
import CardComponent from "./CardComponent/CardComponent";
import Image from "next/image";
import ApplicationImage from "../../../public/assets/ApplicationDevelopmentImage.gif";
import DesignIcon from "@/component/icons/DesignIcon";
import CodingLanguage from "@/component/icons/CodingLanguage";
import SecurityIcon from "@/component/icons/SecurityIcon";
import HostingIcon from "@/component/icons/HostingIcon";
import ApplicationIcon from "@/component/icons/ApplicationIcon";
import One from "@/component/icons/numbers/One";
import Two from "@/component/icons/numbers/Two";
import Three from "@/component/icons/numbers/Three";
import Four from "@/component/icons/numbers/Four";
import Five from "@/component/icons/numbers/Five";
import Six from "@/component/icons/numbers/Six";

// تعريف نوع الأيقونات
type IconMapType = {
  Analysis: JSX.Element;
  Design: JSX.Element;
  Development: JSX.Element;
  Testing: JSX.Element;
  Launching: JSX.Element;
  Support: JSX.Element;
};

const iconMap: IconMapType = {
  Analysis: <AnalysisIcon />,
  Design: <DesignIcon />,
  Development: <CodingLanguage />,
  Testing: <SecurityIcon />,
  Launching: <HostingIcon />,
  Support: <ApplicationIcon />,
};

// تعريف أيقونات الأرقام
const numberIconMap: { [key: number]: JSX.Element } = {
  1: <One />,
  2: <Two />,
  3: <Three />,
  4: <Four />,
  5: <Five />,
  6: <Six />,
};

const ApplicationDevelopment = () => {
  const { t } = useTranslation();
  const steps = t('applicationDevelopment.steps', { returnObjects: true }) as Array<{
    title: keyof IconMapType;
    description: string;
  }>;

  return (
    <section className="py-12 mb-10 md:mb-0">
      <div className="container mx-auto px-4 pb-5 relative">
        <div className="flex flex-col items-center w-full title-position pr-0 lg:pr-6">
          <SectionTitle color="black">{t('applicationDevelopment.title')}</SectionTitle>
        </div>
        <div className="flex flex-col lg:flex-row items-center justify-center">
        <div className="flex lg:hidden justify-center lg:w-auto h-full w-full">
            <Image
              src={ApplicationImage}
              width={480}
              height={700}
              alt="Application image"
              className="object-cover"
            />
          </div>
          <div className="flex flex-col items-center w-full lg:w-auto gap-4">
            {steps.slice(0, 3).map((step, index) => (
              <CardComponent
                key={index}
                icon={iconMap[step.title]}
                numberIcon={numberIconMap[index + 1]}
                title={step.title}
                description={step.description}
              />
            ))}
          </div>
          <div className="lg:flex hidden justify-center h-[110vh] w-full lg:w-auto">
            <Image
              src={ApplicationImage}
              width={480}
              height={700}
              alt="Application image"
              className="object-cover"
            />
          </div>
          <div className="flex flex-col items-center w-full lg:w-auto gap-4">
            {steps.slice(3).map((step, index) => (
              <CardComponent
                key={index + 3} 
                icon={iconMap[step.title]}
                numberIcon={numberIconMap[index + 4]} 
                title={step.title}
                description={step.description}
              />
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};
export default ApplicationDevelopment;