import React, { ReactNode } from "react";
import { useTranslation } from 'react-i18next';

interface CardComponentProps {
  icon: ReactNode;
  numberIcon: ReactNode;
  title: string;
  description: string;
}

const CardComponent = ({
  icon,
  numberIcon,
  title,
  description,
}: CardComponentProps) => {
  const {  i18n } = useTranslation();
  const currentLanguage = i18n.language;
  const textDirectionClass = currentLanguage === 'ar' ? 'text-rtl text-[16px] font-medium font-cairo' : 'text-ltr text-sm font-sfpro font-normal';

  return (
    <div className="relative rounded-xl cardShadow p-4 mb-3 w-[350px] md:w-[392px] md:h-[172px]">
      <div className="flex items-center pb-5">
        {icon}
        <h1 className="font-sfpro ml-5 font-semibold text-xl text-[#101828]">
          {title}
        </h1>
      </div>
      <p className={`text-[#101828] ${textDirectionClass}`}>
        {description}
      </p>
      <div className="absolute top-0 right-0 -z-10">{numberIcon}</div>
    </div>
  );
};

export default CardComponent;
