import { SwiperSlide } from "swiper/react";
import SwiperComponent from "../../mucles/SwiperComponent";
import Image from "next/image";
import { useTranslation } from "react-i18next";
import Link from "next/link";

const OurProjects = ({ data }: any) => {
  const { t, i18n } = useTranslation();
  const dir = i18n.language === "ar" ? "rtl" : "ltr";
  const projects = data?.result?.data || [];
  console.log(projects);
  
  return (
    <section className="pb-12">
      <SwiperComponent
        phoneSlides={1}
        Slides={3}
        title={t("ourProjects.title")}
      >
        {projects.length > 0 ? (
          projects.map((project: any) => (
            <SwiperSlide key={project.id}>
              <Link href={`/project-details/${project.id}`}>
                <div className="mx-auto relative w-[90%] lg:w-full h-[250px] sm:h-[350px] md:h-[422px] cursor-pointer">
                  <Image
                    src={project.card.image || '/default-image.png'}
                    alt={`Project Image ${project.id}`}
                    fill
                    style={{ objectFit: "cover" }}
                    className="rounded-lg"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-black to-transparent rounded-lg opacity-0 hover:opacity-100 transition-opacity duration-300">
                    <div className="absolute bottom-10 left-0 w-full p-4 text-white text-center">
                      <h3 className="text-lg font-bold">{project.card.title}</h3>
                      <p className="text-sm">{project.card.description}</p>
                    </div>
                  </div>
                </div>
              </Link>
            </SwiperSlide>
          ))
        ) : (
          <div className="text-center text-white font-medium" dir={dir}>
            {t("ourProjects.noProjects")}...
          </div>
        )}
      </SwiperComponent>
    </section>
  );
};

export default OurProjects;
