import SectionTitle from "@/component/mucles/sectionTitle/SectionTitle";
import Service from "./Service/Service";
import { useTranslation } from "react-i18next";


interface ServiceType {
  title: string;
  description: string;
}

const OurServices = () => {
  const { t, i18n } = useTranslation();
  const services: ServiceType[] = t("services.services", {
    returnObjects: true,
  });
  const currentLanguage = i18n.language;

  // تحديد الفئة المناسبة بناءً على اللغة
  const textDirectionClass = currentLanguage === "ar" ? "text-rtl" : "text-ltr";

  return (
    <section className="services rounded-t-3xl flex justify-center flex-col items-center relative" id="our-services">
      <div className="flex items-center w-full">
        <SectionTitle color="black">{t("services.title")}</SectionTitle>
      </div>
      <div
        className={`grid grid-cols-1 md:grid-cols-3 md:px-12 px-5 gap-6 ${textDirectionClass}`}
      >
        {services.map((service: ServiceType, index: number) => (
          <Service
            key={index}
            title={service.title}
            description={service.description}
          />
        ))}
      </div>

    </section>
  );
};

export default OurServices;
