import ServicesIcon from "@/component/icons/ServicesIcon";
type ServiceProps = {
  title: string;
  description: string;
  style?: React.CSSProperties;
};
const Service = ({ title, description }: ServiceProps) => {
  return (
    <div className="flex lg:py-3 py-0 px-2">
      <div className="pl-2">
        <ServicesIcon />
      </div>
      <div className="flex-col lg:pb-2 pb-0 space-y-1 lg:space-y-2 font-cairo">
        <h2 className="text-[#101828] text-sm md:text-lg font-semibold">{title}</h2>
        <p className="font-light text-[11px] md:text-sm leading-6 text-[#101828a4]">{description}</p>
      </div>
    </div>
  );
};

export default Service;
