import { useTranslation } from "react-i18next";
import CountUp from 'react-countup';
import { useInView } from 'react-intersection-observer';
import Partners from "../partners/Partners";

interface StatisticsType {
  number: string;
  title: string;
}

const OurStatistics = () => {
  const { t } = useTranslation();
  const { ref, inView } = useInView({ triggerOnce: true });

  const statistics: StatisticsType[] = t("statistics", { returnObjects: true }) || [];

  const formatNumber = (number: string) => {
    const numberOnly = parseFloat(number.replace(/[^0-9.]/g, ''));
    return (
      <CountUp
        start={0}
        end={numberOnly}
        duration={4}
        separator=","
        prefix={number.includes('+') ? '+' : ''}
        decimals={number.includes('.') ? number.split('.')[1].length : 0}
        redraw={true}
      />
    );
  };

  const statisticItems = statistics.map((statistic: StatisticsType, index: number) => (
    <div key={index} className="flex flex-col items-center">
      <h1 className="md:text-7xl text-3xl font-medium">
        {inView ? formatNumber(statistic.number) : statistic.number}
      </h1>
      <p className="md:text-lg text-[10px] font-semibold">{statistic.title}</p>
    </div>
  ));

  return (
    <section ref={ref} className="flex items-center justify-center px-5">
      <div className="h-3/4 w-full py-20 bg-gradient-to-r from-[#0C3580] to-[#1BBBCF] rounded-3xl shadow-lg flex items-center justify-center font-cairo">
        <div className=" gap-8 text-white text-center">
          <div>
            <div className="flex flex-col lg:flex-row justify-center items-center pb-10 gap-10 lg:gap-20">
              {statisticItems}
            </div>
          </div>
          <div>
            <Partners />
          </div>
        </div>
      </div>
    </section>
  );
};

export default OurStatistics;
