import Image from "next/image";
import AmazonIcon from "@/public/assets/Mobile app store badge/Store=Amazon Appstore, Style=Black.svg";
import AppStoreIcon from "@/public/assets/Mobile app store badge/Store=App Store, Style=Black.svg";
import AppGalleryIcon from "@/public/assets/Mobile app store badge/Store=AppGallery, Style=Black.svg";
import ChromebookIcon from "@/public/assets/Mobile app store badge/Store=Chromebook, Style=Black.svg";
import FDroidIcon from "@/public/assets/Mobile app store badge/Store=F-Droid, Style=Black.svg";
import GalaxyStoreIcon from "@/public/assets/Mobile app store badge/Store=Galaxy Store, Style=Black.svg";
import GooglePlayIcon from "@/public/assets/Mobile app store badge/Store=Google Play, Style=Black.svg";
import MicrosoftIcon from "@/public/assets/Mobile app store badge/Store=Microsoft, Style=Black.svg";
import OneStoreIcon from "@/public/assets/Mobile app store badge/Store=One Store, Style=Black.svg";

import Link from "next/link";
import { useTranslation } from "react-i18next";

const ProjectDetailsPage = ({ data }: any) => {
    console.log("data:", data);

    const { i18n } = useTranslation();
    const language = i18n.language;
    const textDirectionClass = language === "ar" ? "text-right" : "text-left";
    const formattedDate = new Date(data[0]?.project_created_at).toLocaleDateString(language, {
        weekday: 'long',
        day: 'numeric',
        month: 'long',
        year: 'numeric',
    });

    return (
        <div className="container mx-auto px-5 lg:px-10">
            <div className="w-full flex justify-center my-5">
                <Image src={data[0]?.project_thumpnail || "no image"} alt="project thumpnail" width={0} height={0} className="w-full h-auto" />
            </div>
            <div className={`flex flex-col space-y-5 ${textDirectionClass}`}>
                <p className="text-[#0075FF] font-cairo font-semibold text-sm">{formattedDate}</p>
                <h3 className="text-[#191919] font-cairo font-semibold text-xl lg:pb-3 lg:text-4xl">{data[0]?.project_title}</h3>
                {/* git content from tiny */}
                <div className="font-cairo text-[#404040] text-base" dangerouslySetInnerHTML={{ __html: data[0]?.project_content }} />
            </div>
            <div className="flex flex-col items-center justify-center bg-[#F2F4F7] rounded-xl my-10 py-10">
                <h3 className="font-laxr font-semibold text-lg project-download relative">تحميل التطبيق</h3>
                <div className="flex lg:space-x-5 mt-10 flex-wrap">
                    {data[0]?.links.map((link: any, index: number) => (
                        <div key={index} className="mb-4 px-5 mx-auto lg:p-0">
                            {link.link_type === "preview" ? (
                                <a href={link.link} target="_blank" rel="noreferrer">
                                    <button className="bg-[#000000] text-white font-bold py-2 px-8 rounded w-[120px] h-[40px] flex items-center justify-center">
                                        Preview
                                    </button>
                                </a>
                            ) : (
                                <Link href={link.link} key={index} target="_blank">
                                    <Image
                                        src={
                                            link.link_type === "google play"
                                                ? GooglePlayIcon
                                                : link.link_type === "app store"
                                                    ? AppStoreIcon
                                                    : link.link_type === "galaxy store"
                                                        ? GalaxyStoreIcon
                                                        : link.link_type === "amazon app store"
                                                            ? AmazonIcon
                                                            : link.link_type === "app gallery"
                                                                ? AppGalleryIcon
                                                                : link.link_type === "microsoft"
                                                                    ? MicrosoftIcon
                                                                    : link.link_type === "one store"
                                                                        ? OneStoreIcon
                                                                        : link.link_type === "chromebook"
                                                                            ? ChromebookIcon
                                                                            : link.link_type === "f-droid"
                                                                                ? FDroidIcon
                                                                                : ""
                                        }
                                        alt="download"
                                        width={150}
                                        height={50}
                                        className="object-cover"
                                    />
                                </Link>
                            )}
                        </div>
                    ))}

                </div>
            </div>
        </div>
    );
};

export default ProjectDetailsPage;
