import Link from "next/link";
import Image, { StaticImageData } from "next/image";

interface ProjectCardProps {
    image: string | StaticImageData;
    name: string;
    description: string;
    id: number;
}

const ProjectCard: React.FC<ProjectCardProps> = ({ image, name, description, id }) => {
    return (
        <div className="flex flex-col">
            <div className="relative w-full h-[300px]">
                <Image
                    src={image}
                    alt={name}
                    fill
                    className="rounded-2xl object-cover"
                />
            </div>
            <Link href={`/project-details/${id}`}>
                <div className="flex justify-between items-center mt-5 cursor-pointer cardHover">
                    <div className="flex flex-col items-start space-y-1">
                        <h3 className="font-urbanist text-base lg:text-lg text-black font-semibold capitalize">{name}</h3>
                        <p className="font-urbanist text-[12px] lg:text-sm font-extralight text-[#00000095]">{description}</p>
                    </div>
                    <div className="iconHover">
                        <svg width="45" height="45" viewBox="0 0 45 45" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect x="0.5" y="0.5" width="44" height="44" rx="22" stroke="black" strokeOpacity="0.2" />
                            <path d="M18 28L28 18M28 18H19.6667M28 18V26.3333" stroke="#3978D6" strokeWidth="1.4" strokeLinecap="round" strokeLinejoin="round" />
                        </svg>
                    </div>
                </div>
            </Link>
        </div>
    );
}

export default ProjectCard;
