import "@/styles/globals.css";
import type { AppProps } from "next/app";
import Layout from "@/component/organisms/Layout";
import { MantineProvider } from "@mantine/core";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import "@/utils/i18n";
import { useEffect, useState } from "react";
import { I18nextProvider } from "react-i18next";
import i18n from "@/utils/i18n";
import { ThreeCircles } from "react-loader-spinner";
import Transition from "@/component/mucles/Transition";
import Head from "next/head";
export default function App({ Component, pageProps }: AppProps) {
  const queryClient = new QueryClient({
    defaultOptions: {
      queries: { refetchOnWindowFocus: false },
    },
  });

  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const savedLanguage = localStorage.getItem("language") || "ar";
    i18n.changeLanguage(savedLanguage).then(() => {
      setLoading(false);
    });
  }, []);

  const isRTL = i18n.language === "ar";

  useEffect(() => {
    document.documentElement.lang = isRTL ? "ar" : "en";
  }, [isRTL]);

  if (loading) {
    return (
      <div className="flex items-center justify-center h-screen">
      <ThreeCircles color="#1BBBCF" height={50} width={50} />
    </div>
    );
  }

  return (
    <>
      <Head>
        <title>Soft-Lap</title>
        <meta name="description" content="Soft-Lap" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      <I18nextProvider i18n={i18n}>
        <QueryClientProvider client={queryClient}>
          <MantineProvider>
            <Layout>
              <Transition>
                <Component {...pageProps} />
              </Transition>
            </Layout>
            <ToastContainer />
          </MantineProvider>
        </QueryClientProvider>
      </I18nextProvider>
    </>
  );
}
