import Projectes from "@/component/template/worksPage/Projectes";
import fetchData from "@/FetchData";

interface Project {
  result: {
    data: {
      card: {
        title: string;
        description: string;
        image: string;
      };
      id: number;
    }[];
  };
}

const IndexPage = ({ projectsData }: { projectsData: Project }) => {
  return (
    <div className="mt-[100px]">
      <Projectes data={projectsData} />
    </div>
  );
};

export async function getServerSideProps(context: any) {
  const { params, req, res } = context;

  const keyValuePairs = req?.headers?.cookie?.split(";");
  const languagePair = keyValuePairs?.find((pair: any) =>
    pair.includes("i18next")
  );
  const language = languagePair ? languagePair.split("=")[1] : "ar";
  const projectsData = await fetchData("user/projects", language);

  return {
    props: {
      projectsData: projectsData,
    },
  };
}
export default IndexPage;
