/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./component/**/*.{js,ts,jsx,tsx,mdx}",
    "./app/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  theme: {
    extend: {
      fontFamily: {
        Inter: ["Inter", "Helvetica", "sans-serif"],
        cairo: ["Cairo", "Helvetica", "sans-serif"],
        urbanist: ["Urbanist", "Helvetica", "sans-serif"],
        laxr: ["LAXR", "Helvetica", "sans-serif"],
        sfpro: ["SF Pro Text", "Helvetica", "sans-serif"],
      },
      screens: {
        xs: "375px",
        sm: "640px",
        md: "768px",
        lg: "1024px",
        xl: "1280px",
        
      },
      backgroundImage: {
        'founderBG': "url('/assets/FounderBg.svg')",
      }
    },
  },
  plugins: [],
};